' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System
Imports System.Collections.Generic
Imports System.Configuration
Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa BugManagerDB odpowiada za wprowadzanie i usuwanie bdw z bazy danych.
''' </summary>
''' <remarks></remarks>
Public Class BugManagerDB

#Region "Konstruktor(y)"

  Private Sub New()
    ' Ukryj konstruktor, poniewa ta klasa ma wycznie skadniki wspuytkowane.
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Pobiera pojedynczy bd z bazy danych.
  ''' </summary>
  ''' <param name="id">Identyfikator bdu do pobrania.</param>
  ''' <param name="memberId">Identyfikator czonka zespou, ktry chce pobra bd.</param>
  ''' <returns>Wypeniony obiekt Bug, jeli pozycja zostaa znaleziona w bazie danych, a czonek zespou ma wystarczajce prawa dostpu, w przeciwnym wypadku Nothing.</returns>
  ''' <remarks></remarks>
  Public Shared Function GetBug(ByVal id As Integer, ByVal memberId As Guid) As Bug
    Dim theBug As Bug
    Dim sql As String = "sprocBugSelectSingleItem"

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)

        myCommand.CommandType = CommandType.StoredProcedure
        myCommand.Parameters.AddWithValue("@id", id)
        myCommand.Parameters.AddWithValue("@memberId", memberId)
        myConnection.Open()

        Using myReader As SqlDataReader = _
            myCommand.ExecuteReader(CommandBehavior.CloseConnection)

          If myReader.Read Then
            theBug = New Bug(myReader.GetInt32(myReader.GetOrdinal("Id")))
            theBug.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            theBug.Description = myReader.GetString(myReader.GetOrdinal("Description"))
            theBug.Priority = myReader.GetInt32(myReader.GetOrdinal("Priority"))
            theBug.Application = New NameValue(myReader.GetInt32(myReader.GetOrdinal("ApplicationId")), myReader.GetString(myReader.GetOrdinal("ApplicationDescription")))
            theBug.Feature = New NameValue(myReader.GetInt32(myReader.GetOrdinal("FeatureId")), myReader.GetString(myReader.GetOrdinal("FeatureDescription")))
            theBug.Frequency = New NameValue(myReader.GetInt32(myReader.GetOrdinal("FrequencyId")), myReader.GetString(myReader.GetOrdinal("FrequencyDescription")))
            theBug.Severity = New NameValue(myReader.GetInt32(myReader.GetOrdinal("SeverityId")), myReader.GetString(myReader.GetOrdinal("SeverityDescription")))
            theBug.Reproducibility = New NameValue(myReader.GetInt32(myReader.GetOrdinal("ReproducibilityId")), myReader.GetString(myReader.GetOrdinal("ReproducibilityDescription")))
            theBug.Status = New NameValue(myReader.GetInt32( _
                myReader.GetOrdinal("StatusId")), _
                myReader.GetString(myReader.GetOrdinal("StatusDescription")))

            theBug.CreateMemberId = myReader.GetGuid(myReader.GetOrdinal("CreateMemberId"))
            theBug.UpdateMemberId = myReader.GetGuid(myReader.GetOrdinal("UpdateMemberId"))
            theBug.CreatedDateAndTime = myReader.GetDateTime(myReader.GetOrdinal("CreatedDateAndTime"))
            theBug.UpdatedDateAndTime = myReader.GetDateTime(myReader.GetOrdinal("UpdatedDateAndTime"))
          Else
            theBug = Nothing
          End If
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return theBug
  End Function

  ''' <summary>
  ''' Zwraca list bdw odpowiadajcych przesanym kryteriom wyszukiwania.
  ''' </summary>
  ''' <param name="searchCriteria">Okrela kryteria suce do filtrowania listy bdw.</param>
  ''' <param name="memberId">Identyfikator czonka zespou dajcego listy bedw.</param>
  Public Shared Function GetBugList(ByVal searchCriteria As SearchCriteria, ByVal memberId As Guid) As List(Of Bug)

    Dim sql As String = "sprocBugSelectList"
    Dim theBugList As New List(Of Bug) ' Lista bdw, ktra bdzie przechowywa wszystkie defekty

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        If searchCriteria IsNot Nothing Then
          ' Dodaj identyfikator aplikacji
          If searchCriteria.ApplicationId <> -1 Then
            myCommand.Parameters.AddWithValue("@applicationId", searchCriteria.ApplicationId)
          End If

          ' Dodaj funkcj aplikacji, ktra moe by list rozdzielon przecinkami
          If Not searchCriteria.Feature = String.Empty Then
            myCommand.Parameters.AddWithValue("@feature", searchCriteria.Feature)
          End If

          ' Dodaj istotno, ktra moe by list rozdzielon przecinkami
          If Not searchCriteria.Severity = String.Empty Then
            myCommand.Parameters.AddWithValue("@severity", searchCriteria.Severity)
          End If

          ' Dodaj status, ktra moe by list rozdzielon przecinkami
          If Not searchCriteria.Status = String.Empty Then
            myCommand.Parameters.AddWithValue("@status", searchCriteria.Status)
          End If

          ' Dodaj typ statusu, okrelajcy czy maj by pobrane bdy aktywne, nieaktywne czy wszystkie
          Select Case searchCriteria.StatusType.ToUpper()
            Case "ACTIVE"
              myCommand.Parameters.AddWithValue("@isActiveBug", 0)
            Case "INACTIVE"
              myCommand.Parameters.AddWithValue("@isActiveBug", 1)
            Case Else
              myCommand.Parameters.AddWithValue("@isActiveBug", DBNull.Value)
          End Select

          ' Dodaj priorytet, ktry moe by list rozdzielon przecinkami
          If Not searchCriteria.Priority = String.Empty Then
            myCommand.Parameters.AddWithValue("@priority", searchCriteria.Priority)
          End If

          ' Dodaj identyfikator czonka zespou, ktry moe by list rozdzielon przecinkami
          If Not searchCriteria.FiledBy = String.Empty Then
            myCommand.Parameters.AddWithValue("@member", searchCriteria.FiledBy)
          End If

          ' Dodaj dat rozpoczecia startDate
          If Not searchCriteria.StartDate = DateTime.MinValue Then
            myCommand.Parameters.AddWithValue("@startDate", searchCriteria.StartDate)
          End If

          ' Dodaj dat zakoczenia endDate
          If Not searchCriteria.EndDate = DateTime.MinValue Then
            myCommand.Parameters.AddWithValue("@endDate", searchCriteria.EndDate)
          End If

          ' Dodaj sowo kluczowe
          If Not searchCriteria.Keyword = String.Empty Then
            myCommand.Parameters.AddWithValue("@keyword", searchCriteria.Keyword)
          End If

          ' Dodaj bugId
          If Not searchCriteria.BugId = -1 Then
            myCommand.Parameters.AddWithValue("@bugId", searchCriteria.BugId)
          End If
        End If

        ' Dodaj identyfikator czonka zaspou w celu sprawdzenia praw dostpu
        myCommand.Parameters.AddWithValue("@memberId", memberId)

        Dim theBug As Bug  ' Tymczasowy obiekt bdu do dodania do BugList

        myConnection.Open()
        Using myReader As SqlDataReader = myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          While myReader.Read()
            theBug = New Bug(myReader.GetInt32(myReader.GetOrdinal("Id")))
            theBug.Title = myReader.GetString(myReader.GetOrdinal("Title"))
            theBug.Description = myReader.GetString(myReader.GetOrdinal("Description"))
            theBug.Priority = myReader.GetInt32(myReader.GetOrdinal("Priority"))
            theBug.Application = New NameValue(myReader.GetInt32(myReader.GetOrdinal("ApplicationId")), myReader.GetString(myReader.GetOrdinal("ApplicationDescription")))
            theBug.Feature = New NameValue(myReader.GetInt32(myReader.GetOrdinal("FeatureId")), myReader.GetString(myReader.GetOrdinal("FeatureDescription")))
            theBug.Frequency = New NameValue(myReader.GetInt32(myReader.GetOrdinal("FrequencyId")), myReader.GetString(myReader.GetOrdinal("FrequencyDescription")))
            theBug.Severity = New NameValue(myReader.GetInt32(myReader.GetOrdinal("SeverityId")), myReader.GetString(myReader.GetOrdinal("SeverityDescription")))
            theBug.Reproducibility = New NameValue(myReader.GetInt32(myReader.GetOrdinal("ReproducibilityId")), myReader.GetString(myReader.GetOrdinal("ReproducibilityDescription")))
            theBug.Status = New NameValue(myReader.GetInt32(myReader.GetOrdinal("StatusId")), myReader.GetString(myReader.GetOrdinal("StatusDescription")))
            theBug.CreateMemberId = myReader.GetGuid(myReader.GetOrdinal("CreateMemberId"))
            theBug.UpdateMemberId = myReader.GetGuid(myReader.GetOrdinal("UpdateMemberId"))
            theBug.CreatedDateAndTime = myReader.GetDateTime(myReader.GetOrdinal("CreatedDateAndTime"))
            theBug.UpdatedDateAndTime = myReader.GetDateTime(myReader.GetOrdinal("UpdatedDateAndTime"))
            theBugList.Add(theBug)
          End While
          myReader.Close()
        End Using
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
    Return theBugList
  End Function

  ''' <summary>
  ''' Wstawia nowy lub aktualizuje istniejcy bd w bazie danych.
  ''' </summary>
  ''' <param name="theBug">Obiekt klasy Bug, ktry ma by zachowany.</param>
  ''' <returns>Nowy lub istniejcy identyfikator bdu w bazie danych.</returns>
  Public Shared Function InsertUpdateBug(ByVal theBug As Bug) As Integer
    Dim sql As String = "sprocBugInsertUpdateSingleItem"

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)

        Dim myCommand As SqlCommand = New SqlCommand(sql, myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        If theBug.Id > 0 Then
          myCommand.Parameters.AddWithValue("@id", theBug.Id)
        End If
        myCommand.Parameters.AddWithValue("@title", theBug.Title)
        myCommand.Parameters.AddWithValue("@description", theBug.Description)
        myCommand.Parameters.AddWithValue("@applicationId", theBug.Application.Value)
        myCommand.Parameters.AddWithValue("@featureId", theBug.Feature.Value)
        myCommand.Parameters.AddWithValue("@reproducibilityId", theBug.Reproducibility.Value)
        myCommand.Parameters.AddWithValue("@severityId", theBug.Severity.Value)
        myCommand.Parameters.AddWithValue("@frequencyId", theBug.Frequency.Value)
        myCommand.Parameters.AddWithValue("@statusId", theBug.Status.Value)
        myCommand.Parameters.AddWithValue("@priority", theBug.Priority)
        myCommand.Parameters.AddWithValue("@createMemberId", theBug.CreateMemberId)
        myCommand.Parameters.AddWithValue("@updateMemberId", theBug.UpdateMemberId)

        Dim myParam As SqlParameter = New SqlParameter
        myParam.Direction = ParameterDirection.ReturnValue
        myCommand.Parameters.Insert(0, myParam)

        myConnection.Open()
        myCommand.ExecuteNonQuery()
        theBug.Id = CType(myParam.Value, Integer)
        myConnection.Close()

        Return theBug.Id
      End Using
    Catch ex As Exception
      ' Przelij bd wyej; zostanie przejty przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

#End Region

End Class